/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.util;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.EndimationKeyframe;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EndimationProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modId;
    private final DataGenerator dataGenerator;
    private final ArrayList<EndimationEntry> entries = new ArrayList();

    public EndimationProvider(DataGenerator dataGenerator, String modId) {
        this.dataGenerator = dataGenerator;
        this.modId = modId;
    }

    public static EndimationKeyframe linear(float time, float x, float y, float z) {
        return new EndimationKeyframe(time, new EndimationKeyframe.Transform(() -> Float.valueOf(x), () -> Float.valueOf(y), () -> Float.valueOf(z)), EndimationKeyframe.LINEAR);
    }

    public static EndimationKeyframe linear(float time) {
        return EndimationProvider.linear(time, 0.0f, 0.0f, 0.0f);
    }

    public static EndimationKeyframe catmullRom(float time, float x, float y, float z) {
        return new EndimationKeyframe(time, new EndimationKeyframe.Transform(() -> Float.valueOf(x), () -> Float.valueOf(y), () -> Float.valueOf(z)), EndimationKeyframe.CATMULL_ROM);
    }

    public static EndimationKeyframe catmullRom(float time) {
        return EndimationProvider.catmullRom(time, 0.0f, 0.0f, 0.0f);
    }

    protected abstract void addEndimations();

    protected EndimationEntry endimation(String name) {
        EndimationEntry entry = new EndimationEntry(name);
        this.entries.add(entry);
        return entry;
    }

    public void m_213708_(CachedOutput cachedOutput) {
        HashSet entryNames = Sets.newHashSet();
        Path outputFolder = this.dataGenerator.m_123916_();
        ArrayList<EndimationEntry> entries = this.entries;
        entries.clear();
        this.addEndimations();
        String directory = "assets/" + this.modId + "/endimations/";
        entries.forEach(entry -> {
            if (!entryNames.add(entry.name)) {
                throw new IllegalStateException("Duplicate endimation: " + entry.name);
            }
            Path resolvedPath = outputFolder.resolve(directory + entry.name + ".json");
            try {
                DataResult dataResult = Endimation.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.build());
                Optional error = dataResult.error();
                if (error.isPresent()) {
                    throw new JsonParseException(((DataResult.PartialResult)error.get()).message());
                }
                DataProvider.m_236072_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)dataResult.result().get()), (Path)resolvedPath);
            }
            catch (JsonParseException | IOException e) {
                LOGGER.error("Couldn't save endimation {}", (Object)resolvedPath, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "Endimation generator for " + this.modId;
    }

    protected static final class EndimationEntry
    extends Endimation.Builder {
        private final String name;

        private EndimationEntry(String name) {
            this.name = name;
        }
    }
}

